#include <MsTimer2.h>
#include <stdio.h>
#include <SoftwareSerial.h>
#include "DI-DMC.h"

unsigned long t0;

boolean driving_joint = false;  // 関節制御中ステータス（true: 制御中），
                                // falseにすることで強制的に制御を止めることも可能だが，trueに戻した瞬間に先に設定した角度へ動き始めてしまうので注意．

// 関節角度管理用（0～1023)：floatを使用すると速度が極端に落ちるのでdigitで管理する
int j_angle_error = 0;    // 関節角度誤差（digit）
int j_angle_target;       // 目標角度（digit）
int j_angle_now;          // 現在角度（digit）

// ==== 関数 ====
// 関節角度を取得
int joint_read(void) {
  int val = 0;
  val = analogRead(AN_JT) - J_OFF;
  return val;
}

// 関節角度制御用コマンド
// 相対角度指令
int change_joint_target_rel(int a) {
  return change_joint_target_abs(j_angle_target + a);
}
// 絶対角度指令
int change_joint_target_abs(int a) {
  j_angle_target = a;
  if (j_angle_target < MAX_ANGLE_CW)  j_angle_target = MAX_ANGLE_CW;
  if (j_angle_target > MAX_ANGLE_CCW) j_angle_target = MAX_ANGLE_CCW;
  driving_joint = true;
  return j_angle_target;
}

// 初期設定
void setup() {
  pinMode(DO_RA1, OUTPUT); //ピン番号の入出力設定
  pinMode(DO_RA2, OUTPUT);
  pinMode(DO_LA1, OUTPUT);
  pinMode(DO_LA2, OUTPUT);
  pinMode(DO_RB1, OUTPUT);
  pinMode(DO_RB2, OUTPUT);
  pinMode(DO_LB1, OUTPUT);
  pinMode(DO_LB2, OUTPUT);
  pinMode(DO_JT1, OUTPUT);
  pinMode(DO_JT2, OUTPUT);
  pinMode(AN_JT,  INPUT);
  // シリアルポートの準備
  serial_begin(250000);
  j_angle_target = joint_read();

  // タイマー割り込み（現在，未使用）
  //MsTimer2::set(1000, variable_confirmation);
  //MsTimer2::start();
}

void loop() {
  //while(timming == 0);
  int command_flag;   //1/4追加　解説はパワポ確認
  int bitmask_joint;
  int bitmask_motorA;
  int bitmask_motorB;

  // コマンド解析
  // 読み込み情報の有無確認
  if ( serial_available() > 0 ) {
    command_flag = serial_read(); //　シリアルポートからデータの読み込み
    bitmask_motorA  = (command_flag & B11000000) >> 6;
    bitmask_motorB  = (command_flag & B00110000) >> 4;
    bitmask_joint   = (command_flag & B00001111);
        
    if (command_flag == B11111111) { // 全モーター停止用flag確認
      allmotorStop();
    } else {
      //ロボットA部駆動モーター4個のコマンドの解読
      if      (bitmask_motorA == B11) motorStop_A();
      else if (bitmask_motorA == B10) motorFWD_A();
      else if (bitmask_motorA == B01) motorBWD_A();
      
      //ロボットB部駆動モーター4個のコマンドの解読
      if      (bitmask_motorB == B11) motorStop_B();
      else if (bitmask_motorB == B10) motorFWD_B();
      else if (bitmask_motorB == B01) motorBWD_B();

      // 関節部コマンドの解読（下位4bit）
      if        (bitmask_joint == B1010) {  // 左移動時姿勢(CW)
        change_joint_target_abs(EASY_ANGLE_CW);
      } else if (bitmask_joint == B0101) {  // 右移動時姿勢(CCW)
        change_joint_target_abs(EASY_ANGLE_CCW);
      } else if (bitmask_joint == B1000) {  // 相対角度ｰ15度（CW）
        change_joint_target_rel(-STEP_ANGLE);
      } else if (bitmask_joint == B0100) {  // 相対角度+15度（CCW） 
        change_joint_target_rel( STEP_ANGLE);
      } else if (bitmask_joint == B1100) {  // 関節角度０度
        change_joint_target_abs(512);
      } else if (bitmask_joint == B0011) {  // 関節停止
        jointSTOP();
      } else if (bitmask_joint == B0010) {  // 関節CW（連続）
        jointCW();
      } else if (bitmask_joint == B0001) {  // 関節CCW（連続）
        jointCCW();  
      } else if (bitmask_joint == B1001) {  // 関節角度（ポテンショメーター）のズレを補正
        J_OFF = analogRead(AN_JT) - 512;
      }
    }
  }     

  // 関節角度の取得
  j_angle_now   = joint_read(); // 関節角度の取得（ポテンショメーター）
  j_angle_error = j_angle_target - j_angle_now; 

  // 制御ルーチン
  // 駆動用モーター制御部（正転，逆転，停止）
  if (motorRA == 0) motorStop(DO_RA1);
    else if (motorRA ==  1) motorFWD(MOTOR_RA);
    else if (motorRA == -1) motorBWD(MOTOR_RA);
  if (motorLA == 0) motorStop(DO_LA1);
    else if (motorLA ==  1) motorFWD(MOTOR_LA);
    else if (motorLA == -1) motorBWD(MOTOR_LA);
  if (motorRB == 0) motorStop(DO_RB1);
    else if (motorRB ==  1) motorFWD(MOTOR_RB);
    else if (motorRB == -1) motorBWD(MOTOR_RB);
  if (motorLB == 0) motorStop(DO_LB1);
    else if (motorLB ==  1) motorFWD(MOTOR_LB);
    else if (motorLB == -1) motorBWD(MOTOR_LB);
    
  // 関節部モーター制御部
  if (driving_joint == true){
    if (j_angle_error > 3)         jointCCW();
    else if (j_angle_error < -3)   jointCW ();
    else if (abs(j_angle_error) <= 3) {
      jointSTOP();
      driving_joint = false;
//    serial_write('1');  // 関節角度制御完了のステータスを返信：使用を中止
    }
  }
}

// デバッグ用
void variable_confirmation() {
  int angle_now_degree = map(joint_read,0,1023,0,180);
  char angle_variable[256];
  char now_display[256];
  sprintf(now_display, "現在角度 = %d°", angle_now_degree);
  serial_println(now_display); //12/6 Serial.println→printlnに変更。シリアルポートにデータは送信しない。
  sprintf(angle_variable, "j_angle_error = %d, j_angle_target = %d, j_angle_now = %d\n", j_angle_error, j_angle_target, j_angle_now);
  serial_println(angle_variable);
}

/*
// 全I/Oの状態を読み出す
void robot_condition_check(){
  int read_RA1_4      = digitalRead(DO_RA1);
  int read_RA2_5      = digitalRead(DO_RA2);
  int read_LA1_6      = digitalRead(DO_LA1);
  int read_LA2_7      = digitalRead(DO_LA2);
  int read_RB1_8      = digitalRead(DO_RB1);
  int read_RB2_9      = digitalRead(DO_RB2);
  int read_LB1_10     = digitalRead(DO_LB1);
  int read_LB2_11     = digitalRead(DO_LB2);
  int read_JOINT1_12  = digitalRead(AI_JOINT1);
  int read_JOINT2_13  = digitalRead(AI_JOINT2);
}
*/
